/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.api.convertidores;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.regex.Pattern;
import org.eclipse.core.databinding.conversion.Converter;

public class StringToDoubleConverter
extends Converter {
    private static DecimalFormat formato;
    private static final String REGEX_NUMERO_DECIMAL = "[0-9]*(?:\\.[0-9]*)?";

    static {
        DecimalFormatSymbols simbolos = new DecimalFormatSymbols();
        simbolos.setDecimalSeparator('.');
        formato = new DecimalFormat("0.00", simbolos);
    }

    public StringToDoubleConverter() {
        super(String.class, Double.TYPE);
    }

    public Object convert(Object fromObject) {
        if (!Pattern.matches(REGEX_NUMERO_DECIMAL, fromObject == null ? "" : fromObject.toString())) {
            return null;
        }
        try {
            return fromObject == null ? null : Double.valueOf(formato.parse((String)fromObject).doubleValue());
        }
        catch (Exception exception) {
            return null;
        }
    }
}

